<?php

declare(strict_types=1);

namespace Makro\Tagger\Application\UseCase;

use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\ValueObject\CodingCollectionStats;
use Makro\Tagger\Domain\ValueObject\CodingCollectionStatsPercent;

class GetAdminDashboardData
{
    public function __construct(
        private Context $context
    )
    {
    }

    public function __invoke(): array
    {
        $allCodings = $this->context->codingCollection();
        $summary = new CodingCollectionStatsPercent(
            new CodingCollectionStats($allCodings)
        );

        $data = [];
        $data['shareForCoder2'] = $this->context->shareForCoder2();

        $data['_summary'] = [
            'total' => $summary->total(),
            'unassigned' => $summary->unassigned(),
            'awaiting' => $summary->awaiting(),
            'haveConflicts' => $summary->haveConflicts(),
            'done' => $summary->done(),
        ];

        $data['questions'] = [];
        foreach ($this->context->codingQuestionCollection() as $q) {
            $codings = $allCodings->forQuestion($q);
            $stats = new CodingCollectionStats($codings, $q->text());

            $data['questions'][$stats->name()] = [
                'total' => $stats->totalCount(),
                'unassigned' => $stats->unassignedCount(),
                'awaiting' => $stats->awaitingCount(),
                'haveConflicts' => $stats->haveConflictsCount(),
                'done' => $stats->doneCount(),
            ];
        }

        $coders = [];
        foreach ($this->context->coderCollection() as $coder) {
            $codings = $allCodings->forCoder($coder);
            $submittedCodings = $allCodings->submittedBy($coder);

            $coders[] = [
                'id' => $coder->id(),
                'total' => $codings->count(),
                'done' => $submittedCodings->count(),
            ];
        }

        $data['coders'] = $coders;

        return $data;
    }
}
