<?php

declare(strict_types = 1);

namespace Makro\Tagger\Application\Context;

use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\ContextFactory;
use Makro\Tagger\Domain\Provider\CoderCollectionProvider;
use Makro\Tagger\Domain\Provider\CodingCollectionProvider;
use Makro\Tagger\Domain\Provider\CodingQuestionCollectionProvider;

class Factory implements ContextFactory
{

    public function __construct(
        private CoderCollectionProvider $coderCollectionProvider,
        private CodingQuestionCollectionProvider $codingQuestionCollectionProvider,
        private CodingCollectionProvider $codingCollectionProvider
    ) {}

    public function make(int $surveyId, string $coders, int $shareForCoder2, string $language = 'en'): Context
    {
        return new Context(
            surveyId: $surveyId,
            coders: $coders,
            shareForCoder2: $shareForCoder2,
            language: $language,
            coderCollectionProvider: $this->coderCollectionProvider,
            codingQuestionCollectionProvider: $this->codingQuestionCollectionProvider,
            codingCollectionProvider: $this->codingCollectionProvider
        );
    }
}
