<!doctype html>
<html lang="de">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Coder Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { min-height:100vh; background:#f5f7fb; }
        .login-card {
            max-width: 420px;
            width: 100%;
            border: 0;
            border-radius: 1rem;
            box-shadow: 0 10px 30px rgba(18,38,63,.08);
        }
    </style>
</head>
<body class="d-flex align-items-center justify-content-center">
<div class="card login-card p-3">
    <div class="card-body">
        <h1 class="h4 text-center mb-1">Coder Login</h1>
        <p class="text-secondary text-center mb-4">Please enter your coder id and password</p>

        <?php if ($model->hasErrors()): ?>
            <div class="alert alert-danger text-center">An error occured. Please try again</div>
        <?php endif ?>

        <?= CHtml::beginForm() ?>

            <div class="mb-3">
                <?= CHtml::activeLabel($model, 'id', ['class' => 'form-label']); ?>
                <?= CHtml::activeTextField($model, 'id', ['class' => 'form-control']) ?>
            </div>

            <div class="mb-3">
                <?= CHtml::activeLabel($model, 'password', ['class' => 'form-label']); ?>
                <?= CHtml::activePasswordField($model, 'password', ['class' => 'form-control']) ?>
            </div>

            <?= CHtml::submitButton('login', ['class' => 'btn btn-primary w-100']) ?>
        <?= CHtml::endForm() ?>
    </div>
</div>
</body>
</html>
