<!doctype html>
<html lang="de" data-bs-theme="light">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>OECD Tagger</title>

    <!-- Bootstrap 5.3.8 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-sRIl4kxILFvY47J16cr9ZwB07vP4J8+LH7qKQnuqkuIAvNWLzeN8tE5YBujZqJLB" crossorigin="anonymous">
    <!-- Bootstrap Icons 1.13.1 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.min.css">
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <style>
        :root{
            /* Branding-Farben – hier anpassen */
            --brand-start:#0ea5e9; /* sky */
            --brand-end:#6366f1;   /* indigo */
            --header-gradient:linear-gradient(135deg,var(--brand-start),var(--brand-end));
            --footer-bg:#0b1220;
            --page-bg:#f8fafc;
        }

        body { min-height:100vh;background: #f6f8fb; }
        .card { border: 0; box-shadow: 0 2px 10px rgba(0,0,0,.06); }
        .stat { font-size: clamp(1.25rem, 3vw, 2rem); font-weight: 700; }
        .muted { color: #6c757d; }
        .table thead th { white-space: nowrap; }
        .status-badge { font-weight: 600; }
        .sticky-header { position: sticky; top: 0; z-index: 1000; backdrop-filter: blur(4px); }
        .progress-xs { height: .5rem; }

        header.app-header{
            background-image:var(--header-gradient);
            color:#fff;
        }
        header .subtitle{opacity:.9}

        .btn-logout{
            --bs-btn-color:#fff;
            --bs-btn-border-color:rgba(255,255,255,.6);
            --bs-btn-hover-color:#0b1220;
            --bs-btn-hover-bg:#fff;
            --bs-btn-hover-border-color:#fff;
        }

        .card{border:0;box-shadow:0 6px 24px rgba(0,0,0,.06)}
        footer.app-footer{background:var(--footer-bg);color:rgba(255,255,255,.85)}
    </style>
</head>
<body class="d-flex flex-column">

<!-- Header -->
<header class="app-header py-4">
    <div class="container">
        <div class="d-flex align-items-start justify-content-between gap-3">
            <div>
                <h1 class="h3 mb-1">Tagger</h1>
            </div>

            <?php if (Yii::app()->coder->id): ?>
            <div x-data>

                <?php $action = Yii::app()->createAbsoluteUrl('plugins/direct', [
                    'plugin' => 'Tagger',
                    'action' => 'logout',
                    'sid' => intval($_GET['sid'])
                ]); ?>

                <?= CHtml::beginForm($action, 'post', [
                    'id' => 'logoutForm',
                    'x-ref' => 'logoutForm',
                ]); ?>

                <button type="button" class="btn btn-outline-light" @click="$refs.logoutForm.submit()">
                    <i class="bi bi-box-arrow-right"></i> Logout
                </button>

                <?= CHtml::endForm() ?>
            </div>
            <?php endif ?>

        </div>
    </div>
</header>

<!-- Main -->
<main class="flex-grow-1 py-4">
    <div class="container">
        <div class="row g-4">

            <section class="col-12">
                <div class="card">
                    <div class="card-body">
                        <p class="mb-0">
                            <?= $this->section('content') ?>
                        </p>
                    </div>
                </div>
            </section>
        </div>
    </div>
</main>

<!-- Footer -->
<footer class="app-footer py-4 mt-auto" x-data>
    <div class="container d-flex justify-content-between flex-wrap gap-2">
        <small>&copy; <?= date('Y') ?> Survey Consulting</small>
    </div>
</footer>

</body>
</html>
