<?php $this->layout('layout'); ?>

<main class="container my-4">

    <?php if (Yii::app()->coder->hasFlash('error')): ?>
        <?php $this->insert('alert', [
            'type' => 'danger',
            'dismissible' => true,
            'title' => 'Oops!',
            'message' => Yii::app()->coder->getFlash('error')
        ]); ?>
    <?php endif; ?>

    <div class="row g-3">
        <div class="h-100 col-12 col-md-6 col-lg-9">

            <table class="table">
                <thead>
                <tr>
                    <th>Question</th>
                    <th class="text-center">Done</th>
                    <th class="text-center">Total</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($questions as $question => $data): ?>
                <tr>
                    <td><?= CHtml::link($question, ['plugins/direct', 'plugin' => 'Tagger', 'action' => 'coding', 'sid' => $data['sid'], 'qid' => $data['qid']]) ?></td>
                    <td class="text-center"><?= $data['done'] ?>%</td>
                    <td class="text-center"><?= $data['total'] ?></td>
                </tr>
                <?php endforeach ?>
                </tbody>
            </table>

        </div>

        <div class="h-100 col-12 col-md-6 col-lg-3">

            <div class="card h-100 mb-4">
                <div class="card-body">
                    <div class="muted text-uppercase small">Total Codings</div>
                    <div class="stat"><?= $_summary['total'] ?></div>
                </div>
            </div>

            <div class="card h-100 mb-4">
                <div class="card-body">
                    <div class="muted text-uppercase small">Done-Rate</div>
                    <div class="stat"><span><?= $_summary['done']; ?></span>%</div>
                    <div class="progress progress-xs mt-2"><div class="progress-bar bg-success" style="width:<?= $_summary['done'] ?>%"></div></div>
                </div>
            </div>

        </div>
    </div>
</main>
