<?php

/** @var Makro\Tagger\Domain\ValueObject\Coder $coder */
/** @var int $qid */
/** @var int $sid */
/** @var Makro\Tagger\Domain\Entity\Coding|null $currentCoding */
/** @var int $totalCodingsCount */
/** @var int $doneCodings */
/** @var string $coderHomeUrl */

$this->layout('layout');
?>

<style>
    .btn-group-radio {
        display: flex;
        width: 100%;
        box-shadow: 0 0 0 1px rgba(0,0,0,.125);
        border-radius: 0.375rem;
        overflow: hidden;
    }

    .btn-group-radio .btn {
        flex: 1;
        border-radius: 0 !important;
        border: none;
        border-right: 1px solid rgba(0,0,0,.125);
        margin: 0 !important;
    }

    .btn-group-radio .btn:last-child {
        border-right: none;
    }

    .btn-group-radio .btn-check:checked + .btn {
        background-color: #0d6efd;
        color: white;
    }
</style>

<main class="container my-4"">

    <div class="row g-3">

        <!-- Hauptbereich -->
        <div class="h-100 col-12 col-md-6 col-lg-10">

            <?= CHtml::beginForm(); ?>

            <?= CHtml::hiddenField('responseId', $currentCoding->responseId()) ?>

            <h5><?= CHtml::encode($currentCoding->codingQuestion()->text()) ?></h5>
            <p class="mb-4"><?= CHtml::encode($currentCoding->answer()) ?></p>

            <!-- Tag Options -->
            <div class="mb-3">
                <label class="form-label fw-semibold">Mentalising Level</label>
                <div class="btn-group-radio" role="group">
                    <?php foreach ($tagAnswers as $key => $label): ?>
                        <div>
                            <input type="radio"
                                   class="btn-check"
                                   id="tag-<?= $key ?>"
                                   name="selectedTag"
                                   value="<?= $key ?>"
                                   required
                                   style="position: absolute; opacity: 0;">
                            <label class="btn btn-outline-primary" for="tag-<?= $key ?>">
                                <?= CHtml::encode($label) ?>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- PII Options -->
            <div class="mb-3">
                <label class="form-label fw-semibold">PII Status</label>
                <div class="btn-group-radio" role="group">
                    <?php foreach ($pIIAnswers as $key => $label): ?>
                        <div>
                            <input type="radio"
                                   class="btn-check"
                                   id="pii-<?= $key ?>"
                                   name="selectedPii"
                                   value="<?= $key ?>"
                                   required
                                   style="position: absolute; opacity: 0;">
                            <label class="btn btn-outline-secondary"
                                   for="pii-<?= $key ?>">
                                <?= CHtml::encode($label) ?>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Comment -->
            <div class="mb-3">
                <label class="form-label fw-semibold">Comment (optional)</label>
                <textarea class="form-control" rows="3" name="comment" placeholder="Add your comment..."></textarea>
            </div>

            <!-- Submit -->
            <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-success">
                    Save &amp; Continue
                </button>
            </div>

            <?= CHtml::endForm() ?>

        </div>

        <!-- Seitenbereich -->
        <div class="h-100 col-12 col-md-6 col-lg-2">

            <div class="card mb-4">
                <div class="card-body">
                    <div class="text-muted text-uppercase small">Total Codings</div>
                    <div class="fs-2 fw-bold"><?= $totalCodingsCount ?></div>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-body">
                    <div class="text-muted text-uppercase small">Done-Rate</div>
                    <div class="fs-2 fw-bold">
                        <span><?= $doneRate?></span>%
                    </div>
                    <div class="progress mt-2" style="height: 6px;">
                        <div class="progress-bar bg-success" style="width:<?= $doneRate ?>%"></div>
                    </div>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-body">
                    <div class="text-center"><?= CHtml::link('Coder home', $coderHomeUrl, ['class' => 'btn btn-primary']) ?></div>
                </div>
            </div>
        </div>
    </div>
</main>
