<?php $this->layout('layout'); ?>

<main class="container my-4">

    <?php if (Yii::app()->user->hasFlash('error')): ?>
        <?php $this->insert('alert', [
            'type' => 'danger',
            'title' => 'Oops!',
            'message' => Yii::app()->user->getFlash('error')
        ]); ?>
    <?php endif; ?>

    <?php if (Yii::app()->user->hasFlash('success')): ?>
        <?php $this->insert('alert', [
            'type' => 'success',
            'title' => 'Success!',
            'message' => Yii::app()->user->getFlash('success')
        ]); ?>
    <?php endif; ?>

    <div class="row g-3">
        <div class="col-12 col-md-6 col-lg-2">
            <div class="card h-100">
                <div class="card-body">
                    <div class="muted text-uppercase small">Total Codings</div>
                    <div class="stat"><?= $_summary['total'] ?></div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-2">
            <div class="card h-100">
                <div class="card-body">
                    <div class="muted text-uppercase small">Done-Rate</div>
                    <div class="stat"><span><?= $_summary['done'] ?></span>%</div>
                    <div class="progress progress-xs mt-2"><div class="progress-bar bg-success" style="width:<?= $_summary['done'] ?>%"></div></div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-2">
            <div class="card h-100">
                <div class="card-body">
                    <div class="muted text-uppercase small">Konflict-Rate</div>
                    <div class="stat"><span><?= $_summary['haveConflicts'] ?></span>%</div>
                    <div class="progress progress-xs mt-2"><div class="progress-bar bg-danger" style="width:<?= $_summary['haveConflicts'] ?>%"></div></div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <div class="text-uppercase text-muted small">Unassigned</div>
                            <div class="stat"><?= $_summary['unassigned'] ?>%</div>
                        </div>
                        <?php if ($_summary['unassigned'] > 0): ?>
                        <?= CHtml::beginForm($assignCodersUrl) ?>
                            <button type="submit" class="btn btn-primary btn-sm">
                                <i class="bi bi-person-gear me-1"></i> Assign
                            </button>
                        <?= CHtml::endForm() ?>
                        <?php endif ?>
                    </div>
                    <div class="progress progress-xs mt-3">
                        <div class="progress-bar bg-danger" style="width:<?= $_summary['unassigned'] ?>%"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="muted text-uppercase small">Share for Coder 2</div>
                    <div class="stat"><?= $shareForCoder2 ?>%</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Coding Questions Table -->
    <div class="row g-3 mt-1">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <h2 class="h6 mb-0">Coding Questions</h2>
                    </div>
                    <div class="table-responsive mt-3">
                        <table class="table table-sm align-middle">
                            <thead>
                            <tr>
                                <th>Text</th>
                                <th class="text-center">Unassigned</th>
                                <th class="text-center">Awaits</th>
                                <th class="text-center">Conflict</th>
                                <th class="text-center">Done</th>
                                <th class="text-center">Total</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($questions as $key => $item): ?>
                                <tr>
                                    <td>
                                        <div class="fw-semibold"><?= $key ?></div>
                                    </td>
                                    <td class="text-center"><?= $item['unassigned'] ?></td>
                                    <td class="text-center"><?= $item['awaiting'] ?></td>
                                    <td class="text-center"><?= $item['haveConflicts'] ?></td>
                                    <td class="text-center"><?= $item['done'] ?></td>
                                    <td class="text-center fw-semibold"><?= $item['total'] ?></td>
                                </tr>
                            <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Coder Übersicht -->
    <div class="row g-3 mt-1">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <h2 class="h6 mb-0">List of coders</h2>
                    </div>
                    <div class="table-responsive mt-3">
                        <table class="table table-sm align-middle">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th class="text-center">Submitted</th>
                                <th class="text-center">Total</th>
                                <th class="text-center">%</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($coders as $coder): ?>
                                <tr>
                                    <td class="fw-semibold"><?= $coder['id'] ?></td>
                                    <td class="text-center"><?= $coder['done'] ?></td>
                                    <td class="text-center"><?= $coder['total'] ?></td>
                                    <td class="text-center"><?= $coder['total'] > 0 ?  round($coder['done'] / $coder['total'] * 100) : 0?>%</td>
                                </tr>
                            <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
