<?php

use Makro\Tagger\Presentation\Http\RequestHandler\Admin\AssignCodersRequestHandler;
use Makro\Tagger\Presentation\Http\RequestHandler\Admin\DashboardRequestHandler;
use Makro\Tagger\Presentation\Http\RequestHandler\Coder\CodingRequestHandler;
use Makro\Tagger\Presentation\Http\RequestHandler\Coder\HomeRequestHandler;
use Makro\Tagger\Presentation\Http\RequestHandler\IndexRequestHandler;
use Makro\Tagger\Presentation\Http\RequestHandler\LoginRequestHandler;
use Makro\Tagger\Presentation\Http\RequestHandler\LogoutRequestHandler;

return [
    'index' => IndexRequestHandler::class, // redirects to coder-home
    'coder-home' => HomeRequestHandler::class, // if not logged in, redirects to login
    'coding' => CodingRequestHandler::class, // the page, where coders code
    'login' => LoginRequestHandler::class, // if successful, redirect to coder-home
    'logout' => LogoutRequestHandler::class, // logout and redirect tot coder-home, which should redirect to login

    'admin-dashboard' => DashboardRequestHandler::class, // accessible via LimeSurvey-User
    'assign-coders' => AssignCodersRequestHandler::class, // assign coders
];
