<?php

declare(strict_types=1);

use DI\ContainerBuilder;
use Laminas\Diactoros\ResponseFactory;
use Laminas\HttpHandlerRunner\Emitter\SapiEmitter;
use League\Plates\Engine;
use Makro\Tagger\Application\Context\Factory;
use Makro\Tagger\Domain\Mapper\ColumnMapper;
use Makro\Tagger\Domain\Provider\CoderCollectionProvider;
use Makro\Tagger\Domain\Provider\CodingCollectionProvider;
use Makro\Tagger\Domain\Provider\CodingQuestionCollectionProvider;
use Makro\Tagger\Domain\Repository\CodingQuestionRepository;
use Makro\Tagger\Infrastructure\Mapper\Db\DbColumnMapper;
use Makro\Tagger\Infrastructure\Persistence\Db\DbCodingQuestionRepository;
use Makro\Tagger\Infrastructure\Provider\Db\DbCodingCollectionProvider;
use Makro\Tagger\Infrastructure\Provider\Db\DbCodingQuestionCollectionProvider;
use Makro\Tagger\Infrastructure\Provider\FromStringCoderCollectionProvider;
use Makro\Tagger\Domain\Repository\CodingRepository;
use Makro\Tagger\Infrastructure\Persistence\Db\DbCodingRepository;
use Makro\Tagger\Infrastructure\Routing\PluginUrlGenerator;
use Makro\Tagger\Infrastructure\View\PlatesTemplateRenderer;
use Makro\Tagger\Presentation\Http\NewDirectRequest;
use Makro\Tagger\Presentation\Routing\UrlGenerator;
use Makro\Tagger\Presentation\View\TemplateRenderer;
use Psr\Container\ContainerInterface;
use function DI\autowire;
use function DI\create;

return function (Tagger $plugin): ContainerInterface
{
    $builder = new ContainerBuilder();

    $builder->useAutowiring(true);
    $builder->useAnnotations(false);
    $builder->addDefinitions([

        Tagger::class => $plugin,

        Engine::class => create()
            ->constructor(
                directory: dirname(__DIR__) . '/resources/plates'
            ),

        TemplateRenderer::class => autowire(PlatesTemplateRenderer::class),

        UrlGenerator::class => DI\autowire(PluginUrlGenerator::class)
            ->constructorParameter('pluginName', 'Tagger'),

        ResponseFactory::class => static fn() => new ResponseFactory(),
        SapiEmitter::class => static fn() => new SapiEmitter(),

        NewDirectRequest::class => static function (Psr\Container\ContainerInterface $c): NewDirectRequest {
            return new NewDirectRequest(
                $c,
                require __DIR__ . '/http/handlers.php',
                require __DIR__ . '/http/authmap.php'
            );
        },

        CodingRepository::class => autowire(DbCodingRepository::class),
        CodingQuestionRepository::class => autowire(DbCodingQuestionRepository::class),

        CodingCollectionProvider::class => autowire(DbCodingCollectionProvider::class),
        CoderCollectionProvider::class => autowire(FromStringCoderCollectionProvider::class),
        CodingQuestionCollectionProvider::class => autowire(DbCodingQuestionCollectionProvider::class),
        Factory::class => autowire(),

    ]);

    return $builder->build();
};
