﻿# LimeSurvey Tagger Plugin

Tagging system for longtext and hugetext questions.

- **Name:** Tagger
- **min PHP version:** 8.0
- **supported LimeSurvey versions:** 5.x, 6.x

## Plugin Installation

- Copy the Tagger folder to the LimeSurvey `upload/plugins` directory
- Activate the plugin at the LimeSurvey plugin manager

## Plugin Settings

### General Settings

_Currently none._

### Survey Settings

- `isActive` (boolean)
- `coders` (text)
- `shareForCoder2` (int, 0 - 100)

## Code Architecture (`src/`)

Der Ordner `src/` enthaelt den Kern der Applikation. Er ist in Anwendungsfaelle, Domain-Modelle, Infrastruktur und Hilfsfunktionen aufgeteilt.

### AssignCoders Use Case

- `AssignCoders/Command/AssignCodersCommand.php` transportiert Survey-ID, Sprache, Coder-Liste und den prozentualen Anteil fuer einen Zweitcoder.
- `AssignCoders/CommandHandler/AssignCodersCommandHandler.php` ist der zentrale Anwendungsfall: laedt unzugewiesene Codings, verteilt C1 round-robin, weist optional einen Anteil fuer C2 zu, persistiert das Ergebnis via Repository und kann Ereignisse ausloesen.
- `AssignCoders/Event/CodersAssignedEvent.php` kapselt die Daten fuer ein kuenftiges Event, falls nach erfolgreicher Zuweisung weitere Aktionen folgen sollen.

### Domain Model (`Makro\Tagger\Domain`)

- `CodingQuestion.php`, `CodingQuestions.php` und `CodingQuestionsProvider.php` modellieren taggable Umfragefragen und definieren, wie sie geladen werden.
- `Coding.php` repraesentiert die Codings einer Antwort (C1/C2, Tag, PII, Kommentare, Finalwerte) samt Statuslogik (`Status.php`). Methoden wie `submitC1`, `submitC2` und `resolveConflict` aktualisieren Status und finale Ergebnisse.
- `Codings.php` ist eine Sammelklasse mit Convenience-Methoden, z. B. `unassigned()` fuer unbelegte Antworten.
- `Coder.php` und `Coders.php` beschreiben die verfuegbaren Codierer. `Coders::fromLines()` verarbeitet Konfigurationsdateien im Format `id=>passwort`.
- `CodingRepository.php` definiert das Persistence-Interface mit Methoden zum Laden, Speichern, Pruefen auf Existenz und Zuweisen der Codierer.

### Infrastruktur (`Makro\Tagger\Infrastructure`)

- `Persistence/Db/DbCodingQuestionsProvider.php` fragt LimeSurvey (Yii) nach Fragen, die das Attribut `taggable` besitzen.
- `Persistence/Db/DbCodingRepository.php` arbeitet auf den Survey-Response-Tabellen (`ResponseTable.php`) und nutzt `QuestionCodeToColumn.php`, um Question-Codes in SGQA-Spaltennamen zu uebersetzen. `assignCoders()` schreibt nur, wenn C1/C2-Spalten noch leer sind. `exists()` ist noch offen und als TODO markiert.
- `Persistence/InMemory/*` liefert In-Memory-Implementierungen fuer Tests oder lokale Experimente. Einige Methoden sind als TODO markiert (`findAllForQuestion`, `findOneForQuestion`).

### Helper

- `Helper/QuestionCodeToColumn.php` cached die Zuordnung von Question-Code zu SGQA-Spalte ueber den LimeSurvey `LimeExpressionManager` und stellt Hilfsmethoden wie `requireColumn()` (wirft bei Unbekanntem) oder `qualified()` bereit.

## Typischer Ablauf

1. `DbCodingQuestionsProvider` liefert alle als `taggable` markierten Fragen fuer Survey und Sprache.
2. `AssignCodersCommandHandler` laedt über das Repository alle beantworteten Cases (`submitdate IS NOT NULL`).
3. `Coding::fromRow()` baut pro Antwort ein Domain-Objekt, `Codings::unassigned()` filtert auf offene Faelle.
4. C1 wird gleichmaessig verteilt, ein konfigurierter Anteil erhaelt zusaeztlich einen C2 (immer ungleich C1).
5. `CodingRepository::assignCoders()` persistiert nur leere C1/C2-Spalten, vorhandene Werte bleiben unveraendert.
6. Weitere Bearbeitungsschritte verwenden `Coding::submitC1()/submitC2()` und `resolveConflict()` zur Statuspflege.

## Offene TODOs

- `DbCodingRepository::exists()` implementieren.
- `InMemoryCodingRepository::findAllForQuestion()` und `findOneForQuestion()` vervollstaendigen.
- Event-Dispatching (`CodersAssignedEvent`) einbinden, sobald Benachrichtigungen erforderlich sind.

## Links

- [Contact](mailto:marko.bischof@survey-consulting.com?subject=Tagger)
- [Website](https://www.survey-consulting.com)
- [Shop](https://www.survey-consulting.com/all-products)
